% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcode_clean.R
\name{barcode_clean}
\alias{barcode_clean}
\title{DNA Barcode Clean}
\usage{
barcode_clean(AA_code = 5, AGCT_only = 1)
}
\arguments{
\item{AA_code}{This is the amino acid translation matrix (as implemented through ape) used to check the sequences for stop codons. The following codes are available. The Invertebrate matrix, 5, is the default.
1 is standard code
2 is vertebrate mitochondrial
5 is invert mitochondrial
0 skips the AA clean section}

\item{AGCT_only}{This indicates if records with characters other than AGCT are kept, the default is 1.
1 removes records with non-AGCT
0 is accepting all IUPAC characters}
}
\value{
Output:
A single log file for the running of the function with the name A_Clean_File_########## where the numbers represent the date and time of the run.
The function will also output three files for each fasta file submitted. The first is the distance matrix that was calculated and used to assess the DNA barcode gaps.
This file is named the same as the input file with ‘dist_table.dat' appended to the end of the name. The second file is the total data table file which provides a table
of all submitted records for each data set accompanied with the results from each section of the analysis. This file is named the same as the input fasta with “data_table.dat” appended
to the end, Finally, a fasta file with all outliers and flagged records removed is generated for each input fasta file. This output file is named the same as the input fasta with “no_outlier.fas” appended to the end.
}
\description{
Takes an input fasta file and identifies genus level outliers and species outliers based on the 1.5 x greater than the interquartile range.
It also, if selected, checks the sequence using amino acid translation and has the option to eliminate sequences that have non-IUPAC codes.
Finally, the program calculates the barcode gap for the species in the submitted dataset.
}
\details{
Input: A file folder with one or more fasta files of interest
}
\examples{
\dontrun{
barcode_clean(),
barcode_clean(AA_code = 2, AGCT_only = 0),
barcode_clean(AA_code = 1)
}

}
\references{
<https://github.com/rgyoung6/MACER>
Young, R. G., Gill, R., Gillis, D., Hanner, R. H. (Submitted June 2021). Molecular Acquisition, Cleaning, and Evaluation in R (MACER) - A tool to assemble molecular marker datasets from BOLD and GenBank. Biodiversity Data Journal.
}
\seealso{
auto_seq_download()
create_fastas()
align_to_ref()
}
\author{
Robert G. Young
}
