% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_Stimulation.R
\name{create_Stimulation}
\alias{create_Stimulation}
\title{Function to create a Stimulation.}
\usage{
create_Stimulation(name, description, type, emission)
}
\arguments{
\item{name}{\link{character}: Name of the Stimulation.}

\item{description}{\link{character}: Description of the Stimulation.}

\item{type}{\link{character}: Type of the Stimulation ('TL' or 'OSL').}

\item{emission}{\link{numeric}: emission of the Stimulation [u.a].}
}
\value{
This function return a new Stimulation.
}
\description{
This function create a new Stimulation.
}
\examples{
# Data
name <- "example"
description <- "non realistic stimulation"

wavelength <- seq(200,1000,10)

values <- dnorm(x = wavelength,mean = 500,sd = 25)
values <- values/max(values)

emission <- matrix(data=c(wavelength,
                          values),
                   nrow = 81,
                   ncol = 2,
                   byrow = FALSE)

stimulation <- create_Stimulation(name = name,
                                  description = description,
                                  type = 'OSL',
                                  emission = emission)

plot_Stimulation(stimulation)

}
\author{
David Strebler, University of Cologne (Germany).
}

