% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LorMe.R
\docType{package}
\name{LorMe-package}
\alias{LorMe}
\alias{LorMe-package}
\title{LorMe: Lightweight One-Line Resolving Microbial Ecology Program}
\description{
Package for lightweight, one-line microbial ecology analysis including
diversity, differential abundance, and network analysis.
}
\section{Data I/O and interoperability}{

\itemize{
\item \code{\link{tax_summary}} - Build S4 object from biom/meta files.
\item \code{\link{Trans_from_phylo}} - Convert \emph{phyloseq} objects to LorMe.
\item \code{\link{Trans_to_phylo}} - Export LorMe to \emph{phyloseq}.
\item \code{\link{Trans_from_microeco}} - Convert \emph{microtable} (microeco) to LorMe.
\item \code{\link{Trans_to_microeco}} - Export LorMe to \emph{microtable}.
\item \code{\link{sub_tax_summary}} - Subset LorMe object by metadata.
\item \code{\link{add_tree}} - Attach a phylogenetic tree to LorMe object.
}
}

\section{Global configuration}{

\itemize{
\item \code{\link{LorMe_options}} - One-line option manager (analysis level, colours, network thresholds, etc.).
\item \code{\link{object_config}} - Interactive helper to set treatment column and comparison list.
}
}

\section{One-line pipeline}{

\itemize{
\item \code{\link{LorMe_pipeline}} - Run alpha diversity, beta diversity, differential abundance, indicator species, per-treatment and combined networks in a single call; results returned as a tidy list.
}
}

\section{Community profiling}{

\itemize{
\item \code{\link{Alpha_diversity_calculator}} - Alpha diversity analysis including Shannon, Simpson, Chao1, etc.
\item \code{\link{structure_plot}} - Community structure analysis including PCA/PCoA/NMDS.
\item \code{\link{community_plot}} - Community composition analysis including Bar, area and alluvial plots.
\item \code{\link{Top_taxa}} - Calculate most abundant taxon across samples.
}
}

\section{Differential analysis}{

\itemize{
\item \code{\link{Deseq_analysis}} - DESeq analysis.
\item \code{\link{indicator_analysis}} - Indicator analysis.
\item \code{\link{differential_bar}} - Differential bar analysis.
\item \code{\link{volcano_plot}} / \code{\link{manhattan}} - Volcano and Manhattan visualizations.
}
}

\section{Network analysis}{

\itemize{
\item \code{\link{network_analysis}} - Co-occurrence network (Cytoscape/Gephi ready).
\item \code{\link{network_withdiff}} - Meta-network integrating differential taxa.
\item \code{\link{network_visual}} / \code{\link{network_visual_re}} - Statistics and visualizations.
\item \code{\link{Module_composition}} / \code{\link{Module_abundance}} - Module summaries and per-sample abundances.
\item \code{\link{nc}} / \code{\link{NC_remove}} - Natural connectivity metrics.
}
}

\section{Utility functions}{

\itemize{
\item \code{\link{Filter_function}} - Pre-filter OTU/ASV by prevalence or abundance.
\item \code{\link{theme_zg}} - ggplot2 theme optimized for figures.
\item \code{\link{color_scheme}} - Ten built-in color ramps.
\item \code{\link{auto_signif_test}} - Automatic multiple comparison.
\item \code{\link{compare_plot}} - Quick comparison plot generator.
}
}

\author{
Ningqi Wang
}
