% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circulation_lm.R
\name{circulation_lm}
\alias{circulation_lm}
\title{Circulation of fitting Linear Models}
\usage{
circulation_lm(y, xframe, margin)
}
\arguments{
\item{y}{Dependent variable}

\item{xframe}{Matrix or data frame of independent variable}

\item{margin}{A vector of 1 or 2 indicates arrangement of xframe. 1:by rows 2:by columns}
}
\value{
Data frame contains lm statistics of all Independent Variable
}
\description{
Using circulation to fit linear models between one dependent variable and series of independent variable
}
\details{
if row names(for margin 1) and column names(for margin 2) are not given, ID column of return data frame will be row/column numbers.
}
\note{
Other arguments used in function lm were set as default. See in  \code{\link{lm}}.
}
\examples{
data(testotu)

###using margin 1, arrange by rows##
dep=testotu[1,2:21]
in_dep=testotu[-1,2:21]
lm_stat<-circulation_lm(y = dep,xframe = in_dep,margin = 1)
lm_stat

###using margin 2, arrange by column##
dep=testotu[,2]
in_dep=testotu[,3:21]
lm_stat<-circulation_lm(y = dep,xframe = in_dep,margin = 2)
lm_stat

}
\author{
Wang Ningqi\href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
