% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuneiform_plot.R
\name{cuneiform_plot}
\alias{cuneiform_plot}
\title{Create cuneiform plots of result table from longdat_disc() or
longdat_cont()}
\arguments{
\item{result_table}{The result table from longdat_disc() or
longdat_cont() output, or any data frame that has the same format.}

\item{x_axis_order}{The plotting order of the x axis.
It should be a character vector
(e.g. c("Effect_1_2", "Effect_2_3", "Effect_1_3")).}

\item{covariate_panel}{A boolean vector indicating whether to plot
covariate status alongside the effect panel. The default is TRUE.}

\item{pos_color}{The color for a positive effect size.
It should be a hex color code (e.g. "#b3e6ff") or the colors recognized
by R. The default is "red".}

\item{neg_color}{The color for a negative effect size.
It should be a hex color code (e.g. "#b3e6ff") or the colors recognized
by R. The default is "blue".}

\item{panel_width}{The width of the effect size panel on the left
relative to the covariate status panel on the right (width set to 1).
It should be a numerical vector. The default is 4.}

\item{title}{The name of the plot title. The default is
"LongDat result cuneiform plot".}

\item{title_size}{The size of the plot title. The default is 20.}

\item{covariate_text_size}{The size of the text in the covariate status
panel. The default is 4.}

\item{x_label_size}{The size of the x label. The default is 10.}

\item{y_label_size}{The size of the y label. The default is 10.}

\item{legend_title_size}{The size of the legend title. The default is 12.}

\item{legend_text_size}{The size of the legend text The default is 10.}
}
\value{
a 'ggplot' object
}
\description{
Create cuneiform plots of result table from longdat_disc() or
longdat_cont()
}
\details{
This function creates a cuneiform plot which displays the
result of longdat_disc() or longdat_cont(). It plots the effect sizes
 within each time interval for each feature, and also shows the covariate
 status. Only the features with non-NS signals will be included in the plot.
 The output is a ggplot object in patchwork structure. For further
 customization of the plot, please refer to the vignette.
}
\examples{
test_disc <- longdat_disc(input = LongDat_disc_master_table,
data_type = "count", test_var = "Time_point",
variable_col = 7, fac_var = c(1:3))
test_plot <- cuneiform_plot(result_table = test_disc[[1]],
x_axis_order = c("Effect_1_2", "Effect_2_3", "Effect_1_3"))
}
