% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pimp.mat.bin.R
\name{pimp.mat.bin}
\alias{pimp.mat.bin}
\title{Predictor Importance Matrix - Classification}
\usage{
pimp.mat.bin(pimps.out, testdata)
}
\arguments{
\item{pimps.out}{R object containing \code{vec.primes}, \code{tmp.mat}, \code{vec.pimpvars}, and \code{list.pimps}.}

\item{testdata}{Out-of-bag sample.}
}
\value{
A list with:
\describe{
\item{pimp.names}{Vector of predictor names.}
\item{pimp.datamat}{Logical matrix of predictors used (columns) in each of the interactions of a sample (rows).}
}
}
\description{
Internal function called in \code{\link{pimp.import}} to construct a binary/logical matrix of predictors used (columns) in each of the interactions of a sample (rows).
}
\details{
NOTE: For regression models, \code{\link{pimp.mat.nonbin}} is used to accommodate complements of logic trees.
}
\references{
Wolf BJ, Hill EG, Slate EH. Logic Forest: an ensemble classifier for discovering logical combinations of binary markers. \emph{Bioinformatics}. 2010;26(17):2183-2189. \doi{10.1093/bioinformatics/btq354}
}
\seealso{
\code{\link{pimp.import}}
}
\author{
Bethany J. Wolf \email{wolfb@musc.edu}
}
\keyword{internal}
