% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate_sequences.quality_score.R
\name{truncate_sequences.quality_score}
\alias{truncate_sequences.quality_score}
\title{Truncate DNA Sequences at Specified Quality Score}
\usage{
truncate_sequences.quality_score(sequences, quality_scores, threshold = 3)
}
\arguments{
\item{sequences}{A character vector of DNA sequences to truncate.}

\item{quality_scores}{A character vector of DNA sequence quality scores encoded in Sanger format.}

\item{threshold}{Numeric. The Phred quality score threshold used for truncation. The default is \code{3} (\emph{i.e.}, each base in a trimmed sequence has a greater than 50\% probability of having been called correctly).}
}
\value{
A list containing two elements. The first element is a character vector of truncated DNA sequences, and the second element is a character vector of quality scores which have been truncated to their corresponding truncated DNA sequences.
}
\description{
Truncates DNA sequences immediately prior to the first occurrence of a Phred quality score being equal to or less than a specified value.
}
\examples{
truncate_sequences.quality_score(sequences=c("ATATAGCGCG","TGCCGATATA","ATCTATCACCGC"),
                                 quality_scores=c("989!.C;F@\"","A((#-#;,2F","HD8I/+67=1>?"),
                                 threshold=3)
}
\seealso{
\code{\link[=truncate_sequences.length]{truncate_sequences.length}} for truncating DNA sequences to a specified length. \cr
\code{\link[=truncate_sequences.probability]{truncate_sequences.probability}} for truncating DNA sequences by cumulative probability that all bases were called correctly.
}
