% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.fastq.R
\name{read.fastq}
\alias{read.fastq}
\title{Read FASTQ Files}
\usage{
read.fastq(file)
}
\arguments{
\item{file}{A string specifying the path to a FASTQ file to read.}
}
\value{
A data frame with fields for sequence names, sequences, comments, and quality scores.
}
\description{
Reads FASTQ files. Does not support the reading of FASTQ files with sequences or quality scores wrapping multiple lines.
}
\examples{
# Get path to example FASTQ file.
path_to_fastq_file<-system.file("extdata",
                                "example_query_sequences.fastq",
                                package="LocaTT",
                                mustWork=TRUE)

# Read the example FASTQ file.
read.fastq(file=path_to_fastq_file)
}
\seealso{
\code{\link[=write.fastq]{write.fastq}} for writing FASTQ files. \cr
\code{\link[=read.fasta]{read.fasta}} for reading FASTA files. \cr
\code{\link[=write.fasta]{write.fasta}} for writing FASTA files.
}
