% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idFunctionsPos.R
\name{idSphPpos}
\alias{idSphPpos}
\title{Sphingoid bases phosphate (SphP) annotation for ESI+}
\usage{
idSphPpos(
  msobject,
  ppm_precursor = 5,
  ppm_products = 10,
  rttol = 3,
  rt,
  adducts = c("M+H"),
  clfrags = c("sphP_M+H-H2O", "sphP_M+H-2H2O", "sphP_M+H-H2O-NH4"),
  clrequired = c(F, F, F),
  ftype = c("BB", "BB", "BB"),
  coelCutoff = 0.7,
  dbs
)
}
\arguments{
\item{msobject}{an msobject returned by \link{dataProcessing}.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursors and product
ions. By default, 3 seconds.}

\item{rt}{rt window where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for Sph in ESI+. Adducts allowed can
be modified in adductsTable (dbs argument).}

\item{clfrags}{vector containing the expected fragments for a given lipid
class. See \link{checkClass} for details.}

\item{clrequired}{logical vector indicating if each class fragment is
required or not. If any of them is required, at least one of them must be
present within the coeluting fragments. See \link{checkClass} for details.}

\item{ftype}{character vector indicating the type of fragments in clfrags.
It can be: "F" (fragment), "NL" (neutral loss) or "BB" (building block).
See \link{checkClass} for details.}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied. By default, 0.8.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}
}
\value{
annotated msobject (list with several elements). The results element
is a data frame that shows: ID, lipid class, CDB (total number of carbons
and double bounds), FA composition (specific chains composition if it has
been confirmed), mz, RT (in seconds), I (intensity), Adducts, ppm (mz error),
confidenceLevel (Subclass, FA level, where chains are known but not their
positions, or FA position level), peakID, and Score (parent-fragment coelution 
score mean in DIA data or relative sum intensity in DDA of all fragments used 
for the identification).
}
\description{
SphP identification based on fragmentation patterns for LC-MS/MS DIA or DDA
data acquired in positive mode.
}
\details{
\code{idSphPpos} function involves 2 steps. 1) FullMS-based
identification of candidate SphP as M+H. 2) Search of SphP class fragments:
neutral loss of 1 or 2 H2O molecules, or H2O and NH4.

Results data frame shows: ID, lipid class, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (mz error), confidenceLevel (in this
case, as SphP only have one chain, only Subclass and FA level are possible).
and Score (parent-fragment coelution score mean in DIA data or relative 
sum intensity in DDA of all fragments used for the identification).
}
\note{
This function has been written based on fragmentation patterns
observed for three different platforms (QTOF 6550 from Agilent, Sinapt G2-Si
from Waters and Q-exactive from Thermo), but it may need to be customized for
other platforms or acquisition settings.
}
\examples{
\dontrun{
msobject <- idSphPpos(msobject)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
