% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{ddaFrags}
\alias{ddaFrags}
\title{MS/MS scan extraction of a precursor in DDA}
\usage{
ddaFrags(candidates, precursors, rawData, ppm)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{precursors}{data frame with the whole list of precursors selected for MS2.}

\item{rawData}{peaklist for MS2 function (MSMS).}

\item{ppm}{m/z tolerance in ppm.}
}
\value{
List of data frames with the fragments for each candidate.
}
\description{
This function searches for the closest precursor selected for MS2 in DDA
that matches mz tolerance and RT window of a list of candidates and extracts
their fragments.
}
\details{
MS2 scans for a given precursor are searched within a rt window from
minrt-rttol/2 to maxrt+rttol/2. If the same precursor was selected several
times along the peak, the closest scan to the rt at the peak maximum is
selected for annotation.

Coelution score for DDA fragments represents their relative intensity within 
the MS2 scan.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
dbs <- assignDB()

MS1 <- LipidMSdata2::msobjectDDAneg$peaklist$MS1
MS1 <- MS1[MS1$isotope \%in\% c("[M+0]"), !colnames(MS1) \%in\% c("isotope", "isoGroup")]
MS2 <- LipidMSdata2::msobjectDDAneg$peaklist$MS2[,c("mz", "RT", "int", "peakID")]
rawData <- rbind(LipidMSdata2::msobjectDDAneg$MS1, LipidMSdata2::msobjectDDAneg$MS2)
precursors <- LipidMSdata2::msobjectDDAneg$metaData$scansMetadata[
LipidMSdata2::msobjectDDAneg$metaData$scansMetadata$collisionEnergy > 0 &
msobjectDDAneg$metaData$scansMetadata$msLevel == 2, c("RT", "precursor", "Scan")]
candidates <- findCandidates(MS1 = MS1, db = dbs$cerdb, ppm = 10,
rt = c(0, 2000), adducts = c("M-H"),
rttol = 10, dbs = dbs, rawData = rawData_neg$rawScans, coelCutoff = 0.8)

coelfrags <- ddaFrags(candidates, precursors, rawData, ppm = 10)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
