ui <- tagList(
  navbarPage(
    theme = shinythemes::shinytheme("flatly"),
    title = div(img(src='iconohorizontal.png',style="margin-top: -14px; padding-right:0px; padding-left:0px; padding-bottom:10px", height = 60, width = 100)),
    windowTitle = "LipidMS",
    id = "inTabset",
    tabPanel(title = "Data import", value = "tab1",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             tags$hr(),
             mainPanel(widht = 4,
                       textInput("jobname", "Job Name",
                                 value = paste("Job", as.character(Sys.Date()), sep = "_")),
                       fileInput("file1", "Choose mzXML File/s",
                                 multiple = TRUE,
                                 accept = c("text/plain",
                                            ".mzXML")),
                       radioButtons("sI_acquisitionmode", "Acquisition Mode",
                                    choices = c(DIA = "DIA",
                                                DDA = "DDA"),
                                    selected = "DIA"),
                       radioButtons("sI_polarity", "Polarity",
                                    choices = c("Positive" = "positive",
                                                "Negative" = "negative"),
                                    selected = "positive"),
                       actionButton("JumpTo2", "Next >", width = "100px", 
                                    style="margin:40px 0px")
            )
    ),
    tabPanel(title = "Data processing", value = "tab2",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             tags$hr(),
             tags$head(
               tags$style(HTML("input[type=\"number\"] {
                               height: 35px; font-size:11px
                               }"))),
             mainPanel(
               position="left",
               fluidRow(column(6, h5(strong("dmzagglom (in ppm)")),
                               h6(em("m/z tolerance used for partitioning and clustering. 5 by default."), style = "color:grey")),
                        column(3, numericInput("dmzagglom_ms1", "MS1", value = 5, min = 0, max = 100, step = 1)),
                        column(3, numericInput("dmzagglom_ms2", "MS2", value = 5, min = 0, max = 100, step = 1))),
               fluidRow(column(6, h5(strong("drtagglom (in seconds)")),
                               h6(em("rt window used for partitioning (in seconds). 25 by default."), style = "color:grey")),
                        column(3, numericInput("drtagglom_ms1", "MS1", value = 25, min = 0, max = 500, step = 1)),
                        column(3, numericInput("drtagglom_ms2", "MS2", value = 25, min = 0, max = 500, step = 1))),
               fluidRow(column(6, h5(strong("drtclust (in seconds)")),
                               h6(em("rt window used for clustering (in seconds). 25 by default."), style = "color:grey")),
                        column(3, numericInput("drtclust_ms1", "MS1", value = 25, min = 0, max = 500, step = 1)),
                        column(3, numericInput("drtclust_ms2", "MS2", value = 25, min = 0, max = 500, step = 1))),
               fluidRow(column(6, h5(strong("minpeak")),
                               h6(em("minimum number of measurements required for a peak. By default, 5 for MS1 and 4 for MS2."), style = "color:grey")),
                        column(3, numericInput("minpeak_ms1", "MS1", value = 5, min = 1, max = 25, step = 1)),
                        column(3, numericInput("minpeak_ms2", "MS2", value = 4, min = 1, max = 25, step = 1))),
               fluidRow(column(6, h5(strong("minint")),
                               h6(em("minimum intensity of a peak. By default, 1000 for MS1 and 100 for MS2."), style = "color:grey")),
                        column(3, numericInput("minint_ms1", "MS1", value = 1000, min = 0, max = 1e5, step = 1)),
                        column(3, numericInput("minint_ms2", "MS2", value = 100, min = 0, max = 1e5, step = 1))),
               fluidRow(column(6, h5(strong("grtgap (in seconds)")),
                               h6(em("maximum rt gap length to be filled. 5 by default."), style = "color:grey")),
                        column(3, numericInput("drtgap_ms1", "MS1", value = 5, min = 0, max = 30, step = 1)),
                        column(3, numericInput("drtgap_ms2", "MS2", value = 5, min = 0, max = 30, step = 1))),
               fluidRow(column(6, h5(strong("drtminpeak (in seconds)")),
                               h6(em("minimum rt width of a peak. 15 by default. At least minpeak within the drtminpeak window are required to define a peak."), style = "color:grey")),
                        column(3, numericInput("drtminpeak_ms1", "MS1", value = 15, min = 0, max = 500, step = 1)),
                        column(3, numericInput("drtminpeak_ms2", "MS2", value = 15, min = 0, max = 500, step = 1))),
               fluidRow(column(6, h5(strong("drtmaxpeak (in seconds)")),
                               h6(em("maximum rt width of a single peak. 100 by default."), style = "color:grey")),
                        column(3, numericInput("drtmaxpeak_ms1", "MS1", value = 100, min = 0, max = 500, step = 1)),
                        column(3, numericInput("drtmaxpeak_ms2", "MS2", value = 100, min = 0, max = 500, step = 1))),
               fluidRow(column(6, h5(strong("maxeicpeaks")),
                               h6(em("maximum number of peaks within one EIC. By default, 5 for 10 and 3 for MS2."), style = "color:grey")),
                        column(3, numericInput("recurs_ms1", "MS1", value = 5, min = 1, max = 50, step = 1)),
                        column(3, numericInput("recurs_ms2", "MS2", value = 10, min = 1, max = 50, step = 1))),
               fluidRow(column(6, h5(strong("weight")),
                               h6(em("weight for assigning measurements to a peak. By default, 2 for MS1 and 3 for MS2."), style = "color:grey")),
                        column(3, numericInput("weight_ms1", "MS1", value = 2, min = 1, max = 10, step = 1)),
                        column(3, numericInput("weight_ms2", "MS2", value = 3, min = 1, max = 10, step = 1))),
               fluidRow(column(6, h5(strong("SN")),
                               h6(em("signal-to-noise ratio. By default, 3 for MS1 and 2 for MS2."), style = "color:grey")),
                        column(3, numericInput("sn_ms1", "MS1", value = 3, min = 1, max = 10, step = 1)),
                        column(3, numericInput("sn_ms2", "MS2", value = 2, min = 1, max = 10, step = 1))),
               fluidRow(column(6, h5(strong("SB")),
                               h6(em("signal-to-base ratio. By default, 3 for MS1 and 2 for MS2."), style = "color:grey")),
                        column(3, numericInput("sb_ms1", "MS1", value = 3, min = 1, max = 10, step = 1)),
                        column(3, numericInput("sb_ms2", "MS2", value = 2, min = 1, max = 10, step = 1))),
               fluidRow(column(6, h5(strong("dmzIso (in ppm)")),
                               h6(em("mass tolerance for isotope matching. 5 by default."), style = "color:grey")),
                        column(3, numericInput("dmzIso_ms1", "MS1", value = 5, min = 0, max = 100, step = 1)),
                        column(3, numericInput("dmzIso_ms2", "MS2", value = 5, min = 0, max = 10, step = 1))),
               fluidRow(column(6, h5(strong("drtIso")),
                               h6(em("rt window for isotope matching. 5 by default."), style = "color:grey")),
                        column(3, numericInput("drtIso_ms1", "MS1", value = 5, min = 0, max = 100, step = 1)),
                        column(3, numericInput("drtIso_ms2", "MS2", value = 5, min = 0, max = 100, step = 1))),
               fluidRow(actionButton("GoBackTo1", "< Previous", width = "100px", 
                                     style="margin:40px 0px"), 
                        actionButton("JumpTo3", "Next >", width = "100px", 
                                     style="margin:40px 0px"))
             )),
    tabPanel(title = "Annotation", value = "tab3",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             tags$hr(),
             mainPanel(fluidRow(column(6, h5(strong("dmzprecursor")),
                                       h6(em("mass tolerance for precursor ions. 5 by default."), style = "color:grey")),
                                column(3, numericInput("dmzprecursor", "", value = 5, min = 0, max = 100, step = 1))),
                       fluidRow(column(6, h5(strong("dmzproducts")),
                                       h6(em("mass tolerance for product ions. 10 by default."), style = "color:grey")),
                                column(3, numericInput("dmzproducts", "", value = 10, min = 0, max = 100, step = 1))),
                       fluidRow(column(6, h5(strong("rttol")),
                                       h6(em("total rt window for coelution between precursor and product ions. 5 by default."), style = "color:grey")),
                                column(3, numericInput("rttol", "", value = 5, min = 0, max = 50, step = 1))),
                       fluidRow(column(6, h5(strong("coelcutoff")),
                                       h6(em("coelution score threshold between parent and fragment ions. Only applied if rawData info is supplied. 0.7 by default."), style = "color:grey")),
                                column(3, numericInput("coelcutoff", "", value = 0.7, min = 0, max = 1, step = 0.05))),
                       tags$hr(),
                       fluidRow(column(6, checkboxGroupInput("lipidClassesPos", "Lipid classes to annotate for ESI+ :",
                                                             c("MG" = "MG",
                                                               "LPC" = "LPC",
                                                               "LPE" = "LPE",
                                                               "PC" = "PC",
                                                               "PE" = "PE",
                                                               "PG" = "PG",
                                                               "Sphingoid bases" = "Sph",
                                                               "Sphingoid bases phosphate" = "SphP",
                                                               "Cer" = "Cer",
                                                               "SM" = "SM",
                                                               "Carnitines" = "Carnitines",
                                                               "CE" = "CE",
                                                               "DG" = "DG",
                                                               "TG" = "TG"),
                                                             selected = c("MG", "LPC", "LPE", "PC", "PE", "PG", "Sph",
                                                                          "SphP", "Cer", "SM", "Carnitines", "CE", "DG", "TG"))),
                                column(6, checkboxGroupInput("lipidClassesNeg", "Lipid classes to annotate for ESI+ :",
                                                             c("FA" = "FA",
                                                               "FAHFA" = "FAHFA",
                                                               "LPC" = "LPC",
                                                               "LPE" = "LPE",
                                                               "LPG" = "LPG",
                                                               "LPI" = "LPI",
                                                               "LPS" = "LPS",
                                                               "PC" = "PC",
                                                               "PE" = "PE",
                                                               "PG" = "PG",
                                                               "PI" = "PI",
                                                               "PS" = "PS",
                                                               "Sphingoid bases" = "Sph",
                                                               "Sphingoid bases phosphate" = "SphP",
                                                               "Cer" = "Cer",
                                                               "CL" = "CL",
                                                               "Bile Acids" = "BA"),
                                                             selected = c("FA", "FAHFA", "LPC", "LPE", "LPG", "LPI",
                                                                          "LPS", "PC", "PE", "PG", "PI", "PS", "Sph",
                                                                          "SphP", "Cer", "CL", "BA")))),
                       tags$hr(),
                       fluidRow(actionButton("GoBackTo2", "< Previous", width = "100px", 
                                             style="margin:40px 0px"), 
                                actionButton("JumpTo4", "Next >", width = "100px", 
                                             style="margin:40px 0px"))
                       )),
    tabPanel(title = "Run", value = "tab4",
             h4("LipidMS: Lipid annotation for LC-MS/MS data"),
             sidebarPanel(width = 2,
                          fluidRow(h5("\nRun your job: ")),
                          fluidRow(actionButton("do", "Run", 
                                                style="color: #fff; background-color: #336666; border-color: #000")),
                          textOutput("txt_result"),
                          tags$hr(),
                          fluidRow(h5("\nDownload your results: "),
                                   h6(em("(Wait until your results show up on the main panel)"))),
                          fluidRow(downloadButton("downloadSummary", "Summary Tables", 
                                                  style="color: #fff; background-color: #336666; border-color: #000")),
                          tags$hr(),
                          fluidRow(downloadButton("downloadPeaklist", "Annotated Peaklists", 
                                                  style="color: #fff; background-color: #336666; border-color: #000")),
                          tags$hr(),
                          fluidRow(downloadButton("downloadPlots", "Plots", 
                                                  style="color: #fff; background-color: #336666; border-color: #000")),
                          fluidRow(actionButton("GoBackTo3", "< Previous", width = "100px", 
                                       style="margin:40px 0px"))
             ),
             mainPanel(
               tabsetPanel(type = "tabs",
                           tabPanel("Summary Tables", tableOutput("summaryTable")),
                           tabPanel("Annotated Peaklists", tableOutput("annotatedPeaklist"))
                           )
             ))
  )
)
