% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idBAneg.R
\name{idBAneg}
\alias{idBAneg}
\title{Bile Acids (BA) annotation for ESI-}
\usage{
idBAneg(MS1, MSMS1, MSMS2 = data.frame(), ppm_precursor = 5,
  ppm_products = 10, rttol = 3, rt = c(min(MS1$RT), max(MS1$RT)),
  adducts = c("M-H"), conjfrag = c("baconj_M-H"),
  bafrag = c("ba_M-H-H2O"), dbs = list(badb = LipidMS::badb, baconjdb =
  LipidMS::baconjdb, adductsTable = LipidMS::adductsTable))
}
\arguments{
\item{MS1}{data frame cointaining all peaks from the full MS function. It
must have three columns: m.z, RT (in seconds) and int (intensity).}

\item{MSMS1}{data frame cointaining all peaks from the low energy function.
It must have three columns: m.z, RT and int.}

\item{MSMS2}{data frame cointaining all peaks from the high energy
function if it is the case. It must have three columns: m.z, RT and int.
Optional.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}

\item{rt}{rt range where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for BA in ESI-. Adducts allowed can
be modified in the adducsTable (dbs argument).}

\item{conjfrag}{character vector containing the fragmentation rules for
the BA-conjugates. By default just taurine and glycine are considered,
but baconjdb can be modified to add more possible conjugates.
See \link{chainFrags} for details. It can also be an empty vector.}

\item{bafrag}{character vector containing the fragmentation rules for
other BA fragments. See \link{chainFrags} for details. It can be an empty
vector.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be changed. If data bases have
been customized using \link{createLipidDB}, they also have to be modified
here.}
}
\value{
List with BA annotations (results) and some additional information
(fragments).
}
\description{
BA identification based on fragmentation patterns for LC-MS/MS
AIF data acquired in negative mode.
}
\details{
\code{idBAneg} function involves 3 steps. 1) FullMS-based
identification of candidate BA as M-H. 2) Search of BA-conjugate fragments if
required. 3) Search of fragments coming from the loss of H2O. If any
fragmentation rule has been defined, only those with MSMS support are kept.

Results data frame shows: ID, class of lipid, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (m.z error), confidenceLevel (MS-only
if no rules are defined, or MSMS level if they are supported by fragments).
}
\note{
Isotopes should be removed before identification to avoid false
positives.
This function has been writen based on fragmentation patterns observed for
two different platforms (QTOF 6550 from Agilent and Sinapt G2-Si from Waters),
but it may need to be customized for other platforms or acquisition settings.
}
\examples{
idBAneg(MS1 = LipidMS::mix_neg_fullMS, MSMS1 = LipidMS::mix_neg_Ce20,
MSMS2 = LipidMS::mix_neg_Ce40)

idBAneg(MS1 = LipidMS::serum_neg_fullMS, MSMS1 = LipidMS::serum_neg_Ce20,
MSMS2 = LipidMS::serum_neg_Ce40)

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
