% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeItems.R
\name{makeItems}
\alias{makeItems}
\title{Generate synthetic rating-scale data with predefined
first and second moments and a predefined correlation matrix}
\usage{
makeItems(n, means, sds, lowerbound, upperbound, cormatrix)
}
\arguments{
\item{n}{(positive, int) number of observations to generate}

\item{means}{(real) target means: a vector of length k
of mean values for each scale item}

\item{sds}{(positive, real) target standard deviations: a vector of length k
of standard deviation values for each scale item}

\item{lowerbound}{(positive, int) a vector of length k
(same as rows & columns of correlation matrix) of values for lower bound
of each scale item (e.g. '1' for a 1-5 rating scale)}

\item{upperbound}{(positive, int) a vector of length k
(same as rows & columns of correlation matrix) of values for upper bound
of each scale item (e.g. '5' for a 1-5 rating scale)}

\item{cormatrix}{(real, matrix) the target correlation matrix:
a square symmetric matrix of values renging between -1 and +1,
and '1' in the diagonal.}
}
\value{
a dataframe of rating-scale values
}
\description{
\code{makeItems()} generates a dataframe of random discrete
values from a (scaled Beta distribution) so the data replicate a rating
scale, and are correlated close to a predefined correlation matrix.
\code{makeItems()} is wrapper function for:
\itemize{
\item \code{lfast()}, which takes repeated samples selecting a vector that
best fits the desired moments, and
\item \code{lcor()}, which rearranges values in each column of the dataframe
so they closely match the desired correlation matrix.
}
}
\examples{

## define parameters

n <- 16

lowerbound <- rep(1, 4)

upperbound <- rep(5, 4)

corMat <- matrix(
  c(
    1.00, 0.25, 0.35, 0.40,
    0.25, 1.00, 0.70, 0.75,
    0.35, 0.70, 1.00, 0.80,
    0.40, 0.75, 0.80, 1.00
  ),
  nrow = 4, ncol = 4
)

dfMeans <- c(2.5, 3.0, 3.0, 3.5)

dfSds <- c(1.0, 1.0, 1.5, 0.75)

## apply function

df <- makeItems(n = n, means = dfMeans, sds = dfSds,
lowerbound = lowerbound, upperbound = upperbound, cormatrix = corMat)

## test function

print(df)

apply(df, 2, mean) |> round(3)

apply(df, 2, sd) |> round(3)

cor(df) |> round(3)


}
