% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iss.R
\name{iss}
\alias{iss}
\title{ISS solver for linear model with lasso penalty}
\usage{
iss(X, y, intercept = TRUE, normalize = TRUE, nvar = min(dim(X)))
}
\arguments{
\item{X}{An n-by-p matrix of predictors}

\item{y}{Response Variable}

\item{intercept}{if TRUE, an intercept is included in the model (and
not penalized), otherwise no intercept is included. Default is TRUE.}

\item{normalize}{if normalize, each variable is scaled to have L2 norm
square-root n. Default is TRUE.}

\item{nvar}{Maximal number of variables allowed in the model.}
}
\value{
An "LB" class object is returned. The list contains the call,
 the type, the path, the intercept term a0 and value for alpha, kappa,
 iter, and meanvalue, scale factor of X, meanx and normx.
}
\description{
Solver for the entire solution path of coefficients for ISS.
}
\details{
The ISS solver computes the whole regularization path for
lasso-penalty for linear model. It gives the piecewise constant
 solution path for Bregman Inverse Scale Space Differential
 Inclusion. It is the asymptotic limit of LB method with kaapa
 goes to infinity and alpha goes to zero.
}
\examples{
#Examples in the reference paper
library(MASS)
library(lars)
n = 200;p = 100;k = 30;sigma = 1
Sigma = 1/(3*p)*matrix(rep(1,p^2),p,p)
diag(Sigma) = 1
A = mvrnorm(n, rep(0, p), Sigma)
u_ref = rep(0,p)
supp_ref = 1:k
u_ref[supp_ref] = rnorm(k)
u_ref[supp_ref] = u_ref[supp_ref]+sign(u_ref[supp_ref])
b = as.vector(A\%*\%u_ref + sigma*rnorm(n))
lasso = lars(A,b,normalize=FALSE,intercept=FALSE,max.steps=100)
attach(lasso)
pdf(file="myplot.pdf")
par(mfrow=c(3,2))
plot(n/lambda,beta[1:100,1],type="l",xlim=c(0,3),ylim=c(min(beta),max(beta)),
     xlab="t",ylab=bquote(beta),main="Lasso")
for (i in 2:100){
  points(n/lambda,beta[1:100,i],type="l")
}
object = iss(A,b,intercept=FALSE,normalize=FALSE)
attach(object, warn.conflicts= FALSE)
plot(t,path[,1],type="s",xlim=c(0,3),
     ylim=c(min(path),max(path)),xlab="t",ylab=bquote(beta),
     main=bquote("ISS"))
for (j in 2:100){
  points(t,path[,j],type="s")
}
detach(object)
kappa_list = c(1,4,16,64)
alpha_list = 1/2/kappa_list
max_step = floor(10*kappa_list)
for (i in 1:4){
  object <- lb(A,b,kappa_list[i],alpha_list[i],family="gaussian",group="ungrouped",
               intercept=FALSE,normalize=FALSE,iter=max_step[i])
  attach(object, warn.conflicts= FALSE)
  plot((0:max_step[i])*alpha,c(0,path[,1]),type="l",xlim=c(0,3),
       ylim=c(min(path),max(path)),xlab="t",ylab=bquote(beta),
       main=bquote(paste("LB ",kappa,"=",.(kappa_list[i]))))
  for (j in 2:100){
    points((0:max_step[i])*alpha,c(0,path[,j]),type="l")
  }
  detach(object)
}
dev.off()
}
\author{
Feng Ruan, Jiechao Xiong and Yuan Yao
}
\references{
Ohser, Ruan, Xiong, Yao and Yin, Sparse Recovery via Differential
 Inclusions, \url{http://arxiv.org/abs/1406.7728}
}
\keyword{regression}

