% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_write_classification}
\alias{opf_write_classification}
\title{Writes into a file the predicted labels produced by the opf classificator}
\usage{
opf_write_classification(classes, file)
}
\arguments{
\item{classes}{The classification list (i.e.,predicted labels) produced by the classifier}

\item{file}{Where you want to save the classification vector}
}
\value{
`NULL`
}
\description{
Writes into a file the predicted labels produced by the opf classificator
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.5,0,0.5,0)
T <- X$training
T2 <- X$testing
Y <- opf_train(T)
opf_write_classification(Y$classification, file.path(tempdir(), "classification.txt"))

}
