% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LexisNexisTools.R
\name{lnt_sample}
\alias{lnt_sample}
\title{Provides a small sample TXT/DOCX file}
\usage{
lnt_sample(
  format = "txt",
  overwrite = FALSE,
  verbose = TRUE,
  path = NULL,
  copy = TRUE
)
}
\arguments{
\item{format}{Either "txt" to get the sample.TXT file or "docx" to get the
format used by Nexis Uni.}

\item{overwrite}{Should the sample file be overwritten if found in the
current working directory?}

\item{verbose}{Display warning message if file exists in current wd.}

\item{path}{The destination path for the sample file (current working
directory if \code{NULL})}

\item{copy}{Logical. Should the file be copied to path/working directory? If
\code{FALSE}, the function only returns the location of the sample file.}
}
\description{
Copies a small TXT sample file (as used by the old Nexis) or a DOCX (as used
by Nexis Uni or Lexis Advance) to the current working directory and returns
the location of this newly created file. The content of the file is made up
or copied from Wikipedia since real articles from LexisNexis fall under
copyright laws and can not be shared.
}
\details{
A small sample database to test the functions of LexisNexisTools
}
\examples{
\dontrun{
  lnt_sample()
}
}
\author{
Johannes Gruber
}
