% Generated by roxygen2 (4.0.2): do not edit by hand
\name{W}
\alias{W}
\alias{deriv_W}
\alias{log_W}
\title{Lambert W function and derivative}
\usage{
W(z, branch = 0)

deriv_W(z, branch = 0, W.z = W(z, branch = branch))

log_W(z, branch = 0, W.z = W(z, branch = branch))
}
\arguments{
\item{z}{a numeric vector of real values; note that \code{W(Inf) = Inf}.}

\item{branch}{either \code{0} or \code{-1} for the principal or non-principal branch solution.}

\item{W.z}{Lambert W function evaluated at \code{z}; see Details below for why this is a useful argument.}
}
\value{
numeric; same dimensions/size as \code{z}.

\code{W} returns numeric, \code{Inf} (for \code{z = Inf}), or \code{NA} if \eqn{z < -1/e}.

Note that \code{W} handles \code{Inf} and \code{NaN} differently to
 \code{\link[gsl]{lambert_W0}} and \code{\link[gsl]{lambert_Wm1}} in the \pkg{gsl} package.
}
\description{
Evaluates the Lambert W function (\code{W}), its first derivative
(\code{deriv_W}), and its logarithm (\code{log_W}).  All of them have
a principal and non-principal branch solution
(\code{branch = 0} (default) or \code{branch = -1}).

\code{W} is a wrapper for \code{\link[gsl]{lambert_W0}} and
\code{\link[gsl]{lambert_Wm1}} in the \pkg{gsl} package.
}
\details{
The Lambert W function \eqn{W(z) = u} is defined as the inverse
of (see \code{\link{H}})
\deqn{ u \exp(u) = z, }
i.e., it satisfies \eqn{W(z) \exp(W(z)) = z}.

Depending \eqn{z} we can distinguish 3 cases:
\describe{
\item{\eqn{z \geq 0}}{solution is unique \code{W(z) = W(z, branch = 0) = W(z, branch = -1)};}
\item{\eqn{-1/e \leq z < 0}}{two solutions: the principal (\code{W(z, branch = 0)})
and non-principal (\code{W(z, branch = -1)}) branch;}
\item{\eqn{z < -1/e}}{ no solution exists in the reals.}
}

The derivative can be expressed as a function of \eqn{W(z)}: \deqn{ W'(z) =
\frac{1}{(1 + W(z)) \exp(W(z))} = \frac{W(z)}{z(1 + W(z))}. }

Note that \eqn{W'(0) = 1} and \eqn{W'(-1/e) = 0}. For this reason it is numerically
faster to pass the value of \eqn{W(z)} as an argument to the derivative
\code{deriv_W}, as it has often been already evaluated in a previous step.

\code{log_W} computes the natural logarithm of \eqn{W(z)}. Similarly to the derivative,
this can be done efficiently since \eqn{\log W(z) = \log z - W(z)}.
}
\examples{
W(5) # exists in the reals
W(-5) # does not exist in the reals

W(-0.25) # "reasonable" input event
W(-0.25, branch = -1) # "extreme" input event

curve(W(x, branch = -1), -1, 2, type="l", col = 2, lwd = 2)
curve(W(x), -1, 2, type="l", add = TRUE, lty = 2)
abline(v = - 1 / exp(1))

# W is the inverse of H
H(0)
W(0)

H(10)
W(H(10))

# At the critical point z = -1, both branches coincide.
H(-1)
W(H(-1))
W(H(-1), branch = -1)

# For lower values, the principal branch gives the 'wrong' solution;
# the non-principal must be used.
H(-10)
W(H(-10), branch = 0)
W(H(-10), branch = -1)
curve(log(x), 0.1, 5, lty = 2, col = 1, ylab = "")
curve(W(x), 0.1, 5, add = TRUE, col = "red")
curve(log_W(x), 0.1, 5, add = TRUE, col = "blue")
grid()
legend("bottomright", c("log(x)", "W(x)", "log(W(x))"),
       col = c("black", "red", "blue"), lty = c(2, 1, 1))
}
\references{
Corless, R. M., G. H. Gonnet, D. E. G. Hare, D. J. Jeffrey and D. E. Knuth
(1996). \dQuote{On the Lambert W function}. Advances in Computational Mathematics, pp. 329-359.
}
\seealso{
\code{\link[gsl]{lambert_W0}} and \code{\link[gsl]{lambert_Wm1}} in
the \pkg{gsl} package.
}
\keyword{math}

