% Generated by roxygen2 (4.0.2): do not edit by hand
\name{H_gamma}
\alias{H_gamma}
\title{H transformation with gamma}
\usage{
H_gamma(u, gamma = 0)
}
\arguments{
\item{u}{a numeric vector of real values.}

\item{gamma}{skewness parameter; default \code{gamma = 0}, which implies
\code{H_gamma(u) = u}.}
}
\value{
numeric; same dimension/size as \code{u}
}
\description{
Skewed Lambert W\eqn{\times} F RV transformation: \eqn{H_{\gamma}(u) = u \exp(\gamma u)}.
}
\examples{
H_gamma(1, gamma = 1)

H_gamma(2) # default: gamma = 0; hence, H(u) = u
H_gamma(0, gamma = 1) # H_gamma(0) = 0 for all gamma
}
\seealso{
\code{\link{H}}
}
\keyword{math}

