\name{Lambda4}
\alias{Lambda4}
\title{Collection of Internal Consistency Reliability Coefficients.}
\description{
    Currently the package includes 14 methods for calculating internal
    consistency reliability but is still growing.  The package allows users
    access to whichever reliability estimator is deemed most appropriate for
    their situation.
}
\section{Functions}{
\itemize{
  \item \code{angoff}: Compute Angoff Coefficient
  \item \code{bin.combs}: Generate Unique Binary Combinations
  \item \code{cov.lambda4}: Compute Covariance Maximized Lambda4
  \item \code{impute.cov}: Compute Covariance Matrix
  \item \code{kristof}: Compute Kristof Coefficient
  \item \code{lambda1}: Compute Guttman's Lambda 1 Coefficient
  \item \code{lambda2}: Compute Guttman's Lambda 2 Coefficient
  \item \code{lambda3}: Compute Guttman's Lambda 3 Coefficient (Coefficent Alpha)
  \item \code{lambda5}: Compute Guttman's Lambda 5 Coefficient
  \item \code{lambda6}: Compute Guttman's Lambda 6 Coefficient
  \item \code{lambdas}: Compute Guttman's Lambda Coefficients
  \item \code{omega.tot}: Compute McDonald's Omega Total
  \item \code{quant.lambda4}: Compute Quantile Lambda 4
  \item \code{raju}: Compute Raju's Coefficient
  \item \code{user.lambda4}: Compute User Specified Lambda 4 (Split-Half)
  }
}
\author{
  Tyler Hunt \email{tyler@psychoanalytix.com}
}
\references{
Cronbach L (1951). "Coefficient Alpha and the Internal Structure of Tests." Psychometrika, 16, 297-334.

Guttman L (1945). "A Basis for Analyzing Test-Retest Reliability." Psychometrika, 10, 255-282.

Callender J, Osburn H (1977). "A Method for Maximizing and Cross-Validating Split-Half Reliability Coefficients." Educational and Psychological Measurement, 37, 819-826.

Callender J, Osburn H (1979). "An Empirical Comparison of Coefficient Alpha, Guttman's Lambda2 and Msplit Maximized Split-Half Reliability Estimates." Journal of Educational Measurement, 16, 89-99. 

Sijtsma K (2009). "On the Use, Misuse, and Very Limited Usefulness of Cronbach's Alpha." Psychometrika, 74(1), 107-120.
}

