% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamtable1.R
\name{gamtable1}
\alias{gamtable1}
\title{Fit a smooth GAM to Table 1 of Litchfield and Wilcoxon (1949)}
\usage{
gamtable1()
}
\value{
A \code{\link{gamObject}} that can be used to predict the corrected values
    (as proportions) from \code{distexpprop5},
    the distance between the expected values (as proportions) and 0.5
}
\description{
Fit a smooth GAM function to replace looking up values in Table 1 of
  Litchfield and Wilcoxon (1949).
}
\details{
Note that for an expected value of 37 Table 1 gives a corrected value of
    9.4, but for an expected value of 63 it gives a corrected value of 90.5.
    To ensure that both values add to 100, I used corrected values of 9.45
    and 90.55. The expected and corrected values from Table 1 are then used
    to build a GAM model, which is used as input to the
    \code{\link{correctval}} function.
}
\examples{
fit <- gamtable1()
summary(fit)
plot(fit)
}
\references{
Litchfield, JT Jr. and F Wilcoxon.  1949.
    A simplified method of evaluating dose-effect experiments.
    Journal of Pharmacology and Experimental Therapeutics 96(2):99-113.
    \href{http://jpet.aspetjournals.org/content/96/2/99.abstract}{[link]}.
}

