% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_lucid.R
\name{predict.lucid}
\alias{predict.lucid}
\title{Predict the outcome based on a fitted LUCID model}
\usage{
\method{predict}{lucid}(object, newG, newZ, newCoG = NULL, newCoY = NULL, response = TRUE, ...)
}
\arguments{
\item{object}{A model fitted and returned by \code{\link{est.lucid}}}

\item{newG}{A new data set of genetic/environmental factors}

\item{newZ}{A new data set of biomarkers}

\item{newCoG}{Optional. A new data set of covariates included in the G->X analysis}

\item{newCoY}{Optional. A new data set of covariates included in the X->Y analysis}

\item{response}{Report the posterior distribution of cluster assignment (and the probability of binary outcome), default is TRUE}

\item{...}{Other parameters to be passed to \code{predict}}
}
\value{
A list contains predicted latent cluster and outcome for each observation
}
\description{
Predict the outcome based on a fitted LUCID model
}
\examples{
\dontrun{
index <- sample(1:2000, 200)
fit <- est.lucid(G = sim1[-index, 1:10], Z = sim1[-index, 11:20], Y = as.matrix(sim1[-index, 21]))
pred <- predict(object = fit, newG = sim1[index, 1:10], newZ = sim1[index, 11:20])
}
}
