% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_lucid.R
\name{boot_lucid}
\alias{boot_lucid}
\title{Bootstrap method to estimate variability of latent clusters}
\usage{
boot_lucid(
  G = NULL,
  CoG = NULL,
  Z = NULL,
  Y,
  CoY = NULL,
  useY = TRUE,
  family = "binary",
  K = 2,
  Pred = TRUE,
  initial = def_initial(),
  itr_tol = def_tol(),
  tunepar = def_tune(),
  R = 100,
  DeltaE = TRUE,
  NCPUs = detectCores() - 1
)
}
\arguments{
\item{G}{Genetic features, a matrix}

\item{CoG}{Covariates to be included in the G->X path}

\item{Z}{Biomarker data, a matrix}

\item{Y}{Disease outcome, a vector}

\item{CoY}{Covariates to be included in the X->Y path}

\item{useY}{Using Y or not, default is TRUE}

\item{family}{"binary" or "normal" for Y}

\item{K}{Pre-specified # of latent clusters, default is 2}

\item{Pred}{Flag to compute posterior probability of latent cluster with fitted model, default is TRUE}

\item{initial}{A list of initial model parameters will be returned for integrative clustering}

\item{itr_tol}{A list of tolerance settings will be returned for integrative clustering}

\item{tunepar}{A list of tuning parameters and settings will be returned for integrative clustering}

\item{R}{The number of bootstrap replicates, default is 100}

\item{DeltaE}{Flag to return the difference in parameter estimate across latent clusters, default is TRUE}

\item{NCPUs}{The number of processes to be used in parallel computing, default is total number of cores minus 1}
}
\value{
\code{boot_lucid} returns an object of list containing a "boot" class object of LUCID fit and a summary of bootstrap results:
\item{Bootstrap}{an object of "boot" class after bootstrapping a LUCID model}
\item{Results}{A summary of bootstrap includes original estimate, a bias of the bootstrap estimate, standard error of the bootstrap estimate, and three types of bootstrap confidence intervals based on normal approximation, basic, percentile bootstrap methods}
}
\description{
\code{boot_lucid} provides SEs of parameter estimates from a LUCID model through bootstrapping.
}
\examples{
\dontrun{
boot_lucid(G = G1, CoG = CoG, Z = Z1, Y = Y1, CoY = CoY, family = "binary", R=500)
}
}
\references{
Cheng Peng, Jun Wang, Isaac Asante, Stan Louie, Ran Jin, Lida Chatzi, Graham Casey, Duncan C Thomas, David V Conti, A Latent Unknown Clustering Integrating Multi-Omics Data (LUCID) with Phenotypic Traits, Bioinformatics, , btz667, https://doi.org/10.1093/bioinformatics/btz667.

Efron, B., Tibshirani, R. Bootstrap Methods for Standard Errors, Confidence Intervals, and Other Measures of Statistical Accuracy. Statist. Sci. 1 (1986), no. 1, 54--75. doi:10.1214/ss/1177013815.
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
\keyword{bootstrap}
\keyword{cluster}
\keyword{latent}
