% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LSD.comparisonplot.r
\name{heatbarplot}
\alias{LSD.heatbarplot}
\alias{heatbarplot}
\title{Color a barplot.}
\usage{
heatbarplot(x, colpal = "heat", simulate = FALSE, daltonize = FALSE,
  cvd = "p", alpha = NULL, rev = FALSE, horizontal = FALSE,
  nrcol = 100, ...)
}
\arguments{
\item{x}{a histogram object.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}) (defaults to "heat", if not specified).}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{rev}{logical: if \code{TRUE} (\code{FALSE} by default), a reversed colorpalette is used.}

\item{horizontal}{logical: if \code{TRUE} (\code{FALSE} by default), rotation of 90 degrees is applied.}

\item{nrcol}{a non-negative integer specifying the number of colors to be used (defaults to 100, if not specified).}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
Depict a histogram object as a barplot in a color encoded fashion based on a kernel density estimate.
}
\examples{
points = 10^4
x = c(rnorm(points/2),rnorm(points/2)+4)
x = sign(x)*abs(x)^1.3
xhist = hist(x,plot = FALSE)

heatbarplot(xhist)
}
\author{
Bjoern Schwalb
}
\seealso{
\code{\link{comparisonplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{barplot}

