% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_quantile_tests.R
\name{empirical_quantile_one_sample}
\alias{empirical_quantile_one_sample}
\title{Test a quantile of an unknown distribution.}
\source{
\itemize{
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Owen. Empirical Likelihood. Chapman & Hall/CRC.
}
}
\usage{
empirical_quantile_one_sample(
  x,
  Q,
  value,
  alternative = "two.sided",
  conf.level = 0.95
)
}
\arguments{
\item{x}{a numeric vector.}

\item{Q}{The quantile. A single numeric number. (.50 is median.)}

\item{value}{A single numeric value that is the hypothesized Q quantile.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test a quantile of an unknown distribution.
}
\details{
For confidence intervals, an endpoint may be outside the observed range of x.
In this case, NA is returned. Reducing confidence or collecting more data
will make the CI computable.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rnorm(25, 0, 1)
empirical_quantile_one_sample(x, .5, 0, "two.sided")

# Null is false
set.seed(1)
x <- rnorm(25, 2, 1)
empirical_quantile_one_sample(x, .5, 1, "greater")
}
