% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_tests.R
\name{gamma_shape_lr_test}
\alias{gamma_shape_lr_test}
\title{Test the shape parameter of a gamma distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
gamma_shape_lr_test(x, shape = 1, alternative = "two.sided")
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{shape}{a number indicating the tested value of the shape parameter.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}
}
\value{
An S3 class containing the test statistic, p value and alternative
hypothesis.
}
\description{
Test the shape parameter of a gamma distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rgamma(100, shape = 1, scale = 2)
gamma_shape_lr_test(x, 1, "two.sided")

# Null is false
set.seed(1)
x <- rgamma(100, shape = 3, scale = 2)
gamma_shape_lr_test(x, 1, "greater")
}
