% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findC.R
\name{findC}
\alias{findC}
\title{Finding best C}
\usage{
findC(timepoints, max.lag = NULL, pi = 0.95, iter = 10)
}
\arguments{
\item{timepoints}{a vector of timepoints used in the dataset}

\item{max.lag}{a numeric value with maximum lags allowed,
if null, defaults to the floor of the number of timepoints divided by 4}

\item{pi}{a numeric value between 0.5 and 1 for the upper bound on the penalty}

\item{iter}{a numeric value with number of penalty}
}
\value{
a vector of length (10 or indicated by iter) different C to be tested
}
\description{
This function computes the best C using the timepoints and max lag in the dataset
}
\examples{
findC(c(0, 5, 10, 15, 20, 25), max.lag = 1, iter = 15)


}
\author{
Thevaa Chandereng, Anthony Gitter
}
