% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_steadiness.R
\name{steadiness}
\alias{steadiness}
\title{steadiness}
\usage{
steadiness(obj2process = NULL, cores2use = 1, filename = "")
}
\arguments{
\item{obj2process}{Raster* object (or its file name). If time series, each layer is one year}

\item{cores2use}{Numeric. Number of cores to use for parallelization. Optional. Default is 1 (no parallelization)}

\item{filename}{Character. Output filename. Optional}
}
\value{
RasterLayer object
}
\description{
steadiness derives the Steadiness Index from a land productivity variable
}
\details{
The Steadiness Index is based on the combination of two metrics calculated per pixel: (1) the slope derived
from a linear regression of the different years of the time series and (2) the net change on the same period. It
results in a 4-class RasterLayer object ranging from (1) strong negative to (4) strong positive ecosystem dynamics.
See Ivits et al. (2013) for further explanations.

Values = 0 in the final map indicates that there is a scarcity of data in the productivity variable
(i.e. only 1 year with data), so that the indicator cannot be calculated
}
\examples{
\donttest{
sb <- raster::brick(paste0(system.file(package='LPDynR'), "/extdata/sb_cat.tif"))
steadiness(obj2process = sb)
}

}
\references{
Ivits, E., M. Cherlet, W. Mehl, and S. Sommer. 2013. “Ecosystem Functional Units Characterized by
Satellite Observed Phenology and Productivity Gradients: A Case Study for Europe.” Ecological Indicators 27: 17–28.
\doi{10.1016/j.ecolind.2012.11.010}
}
\author{
Xavier Rotllan-Puig
}
