% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgpa.R
\name{qgpa}
\alias{qgpa}
\title{Quantile distribution function of Generalized Pareto Distribution}
\usage{
qgpa(u = NULL, RP = 1/(1 - u), para)
}
\arguments{
\item{u}{non-exceedance probability}

\item{RP}{Return Period "don't use in case u is used"}

\item{para}{parameters as c(location, scale, shape)}
}
\value{
Quantile value/s using the inverse of the cumulative distribution function.
}
\description{
Quantile distribution function of Generalized Pareto Distribution
}
\examples{

x <- qgpa(u = 0.99, para = c(10, 0.1, 0.2))
x <- qgpa(RP = 100, para = c(10, 0.1, 0.2))

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
