% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R, R/plot.R
\name{autoplot.summarize}
\alias{autoplot.summarize}
\alias{plot.summarize}
\title{Graphical Display of the Descriptive Statistics}
\usage{
\method{autoplot}{summarize}(
  object,
  type = "mean",
  variable = NULL,
  size.text = 16,
  linewidth = 1.25,
  size = 3,
  ...
)

\method{plot}{summarize}(x, ...)
}
\arguments{
\item{object, x}{an object of class \code{summarize}, output of the \code{summarize} function.}

\item{type}{[character] the summary statistic that should be displayed: \code{"mean"}, \code{"sd"}, \ldots}

\item{variable}{[character] type outcome relative to which the summary statistic should be displayed.
Only relevant when multiple variables have been used on the left hand side of the formula when calling \code{summarize}.}

\item{size.text}{[numeric, >0] size of the text in the legend, x- and y- labels.}

\item{linewidth}{[numeric, >0] thickness of the line connecting the points.}

\item{size}{[numeric, >0] width of the points.}

\item{...}{additional arguments passed to .ggHeatmap when displaying the correlation: \itemize{
\item name.time [character] title for the x- and y- axis.
\item digits.cor [integer, >0] number of digits used to display the correlation.
\item name.legend [character] title for the color scale.
\item title [character] title for the graph.
\item scale [function] color scale used for the correlation.
\item type.cor [character] should the whole correlation matrix be displayed (\code{"both"}),
or only the element in the lower or upper triangle (\code{"lower"}, \code{"upper"}).
\item args.scale [list] arguments to be passed to the color scale.
}}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to generate the plot.
\item \code{plot}: ggplot object.
}
}
\description{
Graphical representation of the descriptive statistics.
}
\section{Functions}{
\itemize{
\item \code{plot(summarize)}: Graphical Display of Missing Data Pattern

}}
\examples{
data(gastricbypassL, package = "LMMstar")
dtS <- summarize(weight ~ time, data = gastricbypassL)
plot(dtS)
dtS <- summarize(glucagonAUC + weight ~ time|id, data = gastricbypassL, na.rm = TRUE)
plot(dtS, variable = "glucagonAUC")
plot(dtS, variable = "glucagonAUC", type = "correlation", size.text = 1)
}
\keyword{hplot}
