% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R, R/plot.R
\name{autoplot.partialCor}
\alias{autoplot.partialCor}
\alias{plot.partialCor}
\title{Graphical Display For Partial Correlation}
\usage{
\method{autoplot}{partialCor}(
  object,
  size.text = 16,
  limits = c(-1, 1.00001),
  low = "blue",
  mid = "white",
  high = "red",
  midpoint = 0,
  ...
)

\method{plot}{partialCor}(x, ...)
}
\arguments{
\item{object, x}{a \code{partialCor} object.}

\item{size.text}{[numeric, >0] size of the font used to display text.}

\item{limits}{[numeric vector of length 2] minimum and maximum value of the colorscale relative to the correlation.}

\item{low, mid, high}{[character] color for the the colorscale relative to the correlation.}

\item{midpoint}{[numeric] correlation value associated with the color defined by argument \code{mid}.}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to create the graphical display.
\item \code{plot}: ggplot object.
}
}
\description{
Extract and display the correlation modeled via the linear mixed model.
}
\section{Functions}{
\itemize{
\item \code{plot(partialCor)}: Graphical Display For Partial Correlation

}}
\examples{
if(require(ggplot2)){
data(gastricbypassL, package = "LMMstar")

e.pCor <- partialCor(c(weight,glucagonAUC)~time, repetition = ~visit|id,
                     data = gastricbypassL)
plot(e.pCor)
}

}
