% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.anova_lmm.R
\name{summary.anova_lmm}
\alias{summary.anova_lmm}
\title{Summary of Testing for a Linear Mixed Models}
\usage{
\method{summary}{anova_lmm}(
  object,
  method = NULL,
  transform = NULL,
  level = 0.95,
  print = TRUE,
  seed = NULL,
  columns = NULL,
  digits = max(3L, getOption("digits") - 2L),
  digits.p.value = max(3L, getOption("digits") - 2L),
  ...
)
}
\arguments{
\item{object}{an \code{anova_lmm} object, output of \code{anova}.}

\item{method}{[character] type of adjustment for multiple comparisons: one of \code{"none"}, \code{"bonferroni"}, \code{"single-step"}, \code{"single-step2"}.}

\item{transform}{[function] function to backtransform the estimates, standard errors, null hypothesis, and the associated confidence intervals
(e.g. \code{exp} if the outcomes have been log-transformed).}

\item{level}{[numeric 0-1] level of the confidence intervals.}

\item{print}{[logical] should the output be printed in the console.
Can be a vector of length 2 where the first element refer to the global tests and the second to the individual tests.}

\item{seed}{[integer] value that will be set before adjustment for multiple comparisons to ensure reproducible results.
Can also be \code{NULL}: in such a case no seed is set.}

\item{columns}{[character vector] Columns to be displayed for each null hypothesis.
Can be any of \code{"estimate"}, \code{"se"}, \code{"statistic"}, \code{"df"}, \code{"null"}, \code{"lower"}, \code{"upper"}, \code{"p.value"}.}

\item{digits}{[interger] number of digits used to display estimates.}

\item{digits.p.value}{[interger] number of digits used to display p-values.}

\item{...}{Not used. For compatibility with the generic method.}
}
\description{
Estimates, p-values, and confidence intevals for linear hypothesis testing, possibly adjusted for multiple comparisons.
}
\details{
By default adjustment for multiple comparisons via a single step max-test adjustment,
either using the multcomp package (equal degrees of freedom) or the copula package (unequal degrees of freedom).
}
