% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_mode.R
\name{llm_parse_structured}
\alias{llm_parse_structured}
\title{Parse structured output emitted by an LLM}
\usage{
llm_parse_structured(x, strict_only = FALSE, simplify = FALSE)
}
\arguments{
\item{x}{Character or \link{llmr_response}.}

\item{strict_only}{If TRUE, do not attempt recovery via substring extraction.}

\item{simplify}{Logical passed to jsonlite::fromJSON (\code{simplifyVector = FALSE} when FALSE).}
}
\value{
A parsed R object (list), or NULL on failure.
}
\description{
Robustly parses an LLM's structured output (JSON). Works on character scalars
or an \link{llmr_response}. Strips code fences first, then tries strict parsing,
then attempts to extract the largest balanced \{...\} or [...].
}
\details{
The return contract is list-or-NULL; scalar-only JSON is treated as failure.

Numerics are coerced to double for stability.
}
