% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_weather_agent.R
\name{get_fresh_weather}
\alias{get_fresh_weather}
\title{Fetch fresh weather data from OpenWeatherMap}
\usage{
get_fresh_weather(location, api_key, units, endpoint_url)
}
\arguments{
\item{location}{Character. City name, ZIP code, or `"lat,lon"`.}

\item{api_key}{OpenWeatherMap API key.}

\item{units}{Unit system, one of `"metric"`, `"imperial"`,
or `"standard"`.}

\item{endpoint_url}{Character. Complete API endpoint URL.}
}
\value{
A named `list` with two elements:
  \itemize{
    \item `raw` - the parsed JSON response.
    \item `formatted` - a concise character string with key weather
          fields for downstream display.
  }
}
\description{
Internal helper that queries the OpenWeatherMap API and converts the
JSON response into a tidy list containing both the raw payload and a
human-readable summary string.
}
\keyword{internal}
