% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SA.R
\name{SA}
\alias{SA}
\title{Simulated Annealing for LHD}
\usage{
SA(
  n,
  k,
  N = 10,
  T0 = 10,
  rate = 0.1,
  Tmin = 1,
  Imax = 5,
  OC = "phi_p",
  p = 15,
  q = 1,
  maxtime = 5
)
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size).}

\item{k}{A positive integer, which stands for the number of columns (or factor size).}

\item{N}{A positive integer, which stands for the number of iterations. The default is set to be 10. A large value of \code{N} will result a high CPU time, and it is recommended to be no greater than 500.}

\item{T0}{A positive number, which stands for the user-defined initial temperature. The default is set to be 10.}

\item{rate}{A positive percentage, which stands for temperature decrease rate, and it should be in (0,1). For example, rate=0.25 means the temperature decreases by 25\% each time. The default is set to be 10\%.}

\item{Tmin}{A positive number, which stands for the minimium temperature allowed. When current temperature becomes smaller or equal to \code{Tmin}, the stopping criterion for current loop is met. The default is set to be 1.}

\item{Imax}{A positive integer, which stands for the maximum perturbations the algorithm will try without improvements before temperature is reduced. The default is set to be 5. For the computation complexity consideration, \code{Imax} is recommended to be smaller or equal to 5.}

\item{OC}{An optimality criterion. The default setting is "phi_p", and it could be one of the following: "phi_p", "AvgAbsCor", "MaxAbsCor", "MaxProCriterion".}

\item{p}{A positive integer, which is the parameter in the phi_p formula, and \code{p} is prefered to be large. The default is set to be 15.}

\item{q}{The default is set to be 1, and it could be either 1 or 2. If \code{q} is 1, \code{dij} is the Manhattan (rectangular) distance. If \code{q} is 2, \code{dij} is the Euclidean distance.}

\item{maxtime}{A positive number, which indicates the expected maximum CPU time given by user, and it is measured by minutes. For example, maxtime=3.5 indicates the CPU time will be no greater than three and half minutes. The default is set to be 5.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD.
}
\description{
\code{SA} returns a \code{n} by \code{k} LHD matrix generated by simulated annealing algorithm (SA)
}
\examples{
#generate a 5 by 3 maximin distance LHD with the default setting
try=SA(n=5,k=3)
try
phi_p(try)   #calculate the phi_p of "try".

#Another example
#generate a 8 by 4 nearly orthogonal LHD
try2=SA(n=8,k=4,OC="AvgAbsCor")
try2
AvgAbsCor(try2)  #calculate the average absolute correlation.

}
\references{
Morris, M.D., and Mitchell, T.J. (1995) Exploratory designs for computer experiments. \emph{Journal of Statistical Planning and Inference}, \strong{43}, 381-402.
}
