% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi_p.R
\name{phi_p}
\alias{phi_p}
\title{Calculate the phi_p Criterion}
\usage{
phi_p(X, p, q = 1)
}
\arguments{
\item{X}{A Matrix.}

\item{p}{A positive integer.}

\item{q}{The default is set to be 1, and it could be either 1 or 2.}
}
\value{
If all inputs are logical, then the output will be a positive number indicating phi_p.
}
\description{
\code{phi_p} returns the phi_p criterion of a LHD
}
\details{
\itemize{
\item \code{X} stands for the design matrix.
\item \code{p} is the parameter in the phi_p formula (see Note Section below), and \code{p} is prefered to be large.
\item If \code{q} is 1 (the default setting), \code{dij} is the rectangular distance. If \code{q} is 2, \code{dij} is the Euclidean distance.
}
}
\note{
\code{\\phi_p = (\\sum_{i=1}^{n-1}\\sum_{j=i+1}^{n}dij^{-p})^{1/p}}
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Calculate the phi_p criterion of toy (with default q and p=50)
phi_p(X=toy,p=50)

#Calculate the phi_p criterion of toy (with q=2 and and p=50)
phi_p(X=toy,p=50,q=2)
}
\references{
Jin, R., Chen, W., and Sudjianto, A. (2005) An efficient algorithm for constructing optimal design of computer experiments. \emph{Journal of Statistical Planning and Inference}, \strong{134}, 268-287.
}
