% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GulPC.R
\name{GulPC}
\alias{GulPC}
\title{Apply the GulPC method to the Laplace factor model}
\usage{
GulPC(data, m)
}
\arguments{
\item{data}{A matrix of input data.}

\item{m}{is the number of first layer principal component}
}
\value{
AU1,AU2,DU3,SigmaUhat
}
\description{
This function performs General Unilateral Loading Principal Component (GulPC) analysis on a given data set. It calculates the estimated values for the first layer and second layer loadings, specific variances, and the mean squared errors.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- GulPC(data, m)
print(results)
}
