% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_activity_single.R
\name{LDA_activity_single}
\alias{LDA_activity_single}
\title{LDA_activity_single}
\usage{
LDA_activity_single(x, name = "cell line a", treat = "no")
}
\arguments{
\item{x}{numeric data.frame or matrix with three columns (cells,
wells, positive wells)}

\item{name}{optional: experiment name (e.g. name of cell line)}

\item{treat}{optional: treatment (e.g. irradiation dose in Gy)}
}
\value{
list object with estimated activity, 95%-confidence interval,
  84%-confidence interval, estimated parameters, corresponding covariance
  matrix, fit-object and p-value for cooperativity-test
}
\description{
calculation of clonogenic activity from data collected by a
  limiting dilution assay (LDA) experiment (i.e. numbers of: cells seeded,
  wells, positive wells).
}
\examples{
x <- data.frame("cells" = c(10,50,100,250),
                "wells" = rep(25,4),
                "positive" = c(2,5,10,20))
act <- LDA_activity_single(x)
data(LDAdata)
cell.line <- unique(LDAdata$name)[1]
x <- subset.data.frame(
      LDAdata,
      subset = (name==cell.line) & (Group == 0))
LDA_activity_single(x[,4:6])
}
