% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std_df.R
\name{std_df}
\alias{std_df}
\title{Create a data frame of all standards}
\usage{
std_df(sample, all.standards)
}
\arguments{
\item{sample}{A raw sample}

\item{all.standards}{List of all standards}
}
\description{
The function creates a data frame with all standards in one data frame. The data frame has the
same energy values as the sample that is loaded.
}
\examples{
data(stdmix)
corr.spec.standards  <- initial_load(specdat[1:4], 
  corr.norm = c(-36, -15, 37, 58))
corr.spec.samples    <- initial_load(specdat[5:8], 
  corr.norm = c(-36, -15, 37, 58))
fit.standards <- std_df(sample = corr.spec.samples[[1]], 
  all.standards = corr.spec.standards)
print(fit.standards)
}
\keyword{approximation,}
\keyword{correction,}
\keyword{standards}

