% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{plotEsts}
\alias{plotEsts}
\title{Plot LBSPR model estimates}
\usage{
plotEsts(LB_obj = NULL, pars = c("Sel", "FM", "SPR"), Lwd = 2.5,
  ptCex = 1.25, axCex = 1.45, labCex = 1.55, doSmooth = TRUE,
  incL50 = FALSE, CIcol = "darkgray", L50col = "gray")
}
\arguments{
\item{LB_obj}{an object of class \code{'LB_obj'} that contains the life history and fishing information}

\item{pars}{a character vectors specifying which plots to create}

\item{Lwd}{line width}

\item{ptCex}{size of plotted points}

\item{axCex}{size of the axis}

\item{labCex}{size of axis label}

\item{doSmooth}{apply the smoother?}

\item{incL50}{include L50 line?}

\item{CIcol}{colour of the confidence interval bars}

\item{L50col}{colour of L50 line (if included)}
}
\description{
A function that plots the estimates of the LBSPR with a smoother line
}
\author{
A. Hordyk
}

