% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{lake_info}
\alias{lake_info}
\title{Lake attribute information}
\usage{
lake_info(dt, name, state)
}
\arguments{
\item{dt}{list of data.frames. output of \code{\link[LAGOSNE]{lagosne_load}}.}

\item{name}{character lake name not caps sensitive}

\item{state}{character state name not caps sensitive}
}
\description{
Return lake attribute information from its name and state.
}
\examples{
\dontrun{
dt <- lagos_load("1.087.1")
lake_info(dt, "Sunapee Lake", "New Hampshire")

  name = c("Oneida Lake", "Sunapee Lake", "Lake Mendota"),
  state = c("New York", "New Hampshire", "Wisconsin"))

  apply(focal_lakes, 1, function(x) lake_info(
    dt = dt, name = x[1], state = x[2]))
}
}
