#' Lioness Algorithm for order-of-addition design
#'
#' \code{LA_OofAC} returns a \code{n} by \code{k} D-optimal order-of-addition design matrix generated by lioness algorithm (LA)
#'
#' @param n A positive integer, which stands for the number of rows (or run size). Note that the maximum of \code{n} cannot be greater than \code{k} factorial.
#' @param k A positive integer, which stands for the number of columns (or factor size).
#' @param m A positive integer, which stands for the number of starting lionesses agents. The default is set to be 100.
#' @param N A positive integer, which stands for the number of iterations. The default is set to be 5000. A large value of \code{N} will result a high CPU time.
#'
#' @return If all inputs are logical, then the output will be a \code{n} by \code{k} order-of-addition design.
#'
#' @examples
#' #generate a D-optimal full OofA with 4 factors.
#' try=LA_OofAC(n=24,k=4,m=10,N=50)
#' try
#'
#' #Another example
#' #generate a D-optimal 11-run OofA with 4 factors.
#' try2=LA_OofAC(n=11,k=4,m=10,N=50)
#' try2
#' @export

LA_OofAC <- function(n, k, m = 100L, N = 5000L) {
  .Call(`_LA_LA_OofAC`, n, k, m, N)
}

#' @rdname LA_OofAC
#' 
#' @param x is a positive integer.
#' 
factorialC <- function(x) {
  .Call(`_LA_factorialC`, x)
}

#' @rdname LA_OofAC
#' 
#' @param a is a positive integer.
#' @param b is a positive integer.
#' 
modC <- function(a, b) {
  .Call(`_LA_modC`, a, b)
}

#' @rdname LA_OofAC
#' 
#' @param n A positive integer, which stands for the number of rows (or run size). Note that the maximum of \code{n} cannot be greater than \code{k} factorial.
#' @param k A positive integer, which stands for the number of columns (or factor size).
#'
rOofAC <- function(n, k) {
  .Call(`_LA_rOofAC`, n, k)
}

#' @rdname LA_OofAC
#' 
#' @param X A matrix object. In general, \code{X} stands for the design matrix.
#'
PWOC <- function(X) {
  .Call(`_LA_PWOC`, X)
}

#' @rdname LA_OofAC
#' 
#' @param X A matrix object. In general, \code{X} stands for the design matrix.
#'
TC <- function(X) {
  .Call(`_LA_TC`, X)
}

#' @rdname LA_OofAC
#' 
#' @param X A matrix object. In general, \code{X} stands for the design matrix.
#'
MOMC <- function(X) {
  .Call(`_LA_MOMC`, X)
}

