% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rOofA.R
\name{rOofA}
\alias{rOofA}
\title{Generate a random order-of-addition design (OofA)}
\usage{
rOofA(n = factorial(k), k)
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size). The default setting of \code{n} is \code{k} factorial, which yields a full order-of-addition design matrix. Note that the maximum of \code{n} cannot be greater than \code{k} factorial.}

\item{k}{A positive integer, which stands for the number of columns (or factor size).}
}
\value{
If all inputs are positive integer, then the output will be a \code{n} by \code{k} design matrix.
}
\description{
\code{rOofA} returns a random \code{n} by \code{k} order-of-addition design matrix
}
\examples{
#generate a full OofA with 4 factors.
toy=rOofA(k=4);toy

#generate a 12-run random OofA with 4 factors.
toy=rOofA(n=12,k=4);toy
}
