% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L1centMDS.R
\name{L1centMDS}
\alias{L1centMDS}
\alias{L1centMDS.igraph}
\alias{L1centMDS.matrix}
\alias{plot.L1centMDS}
\title{Fitting a Target Plot}
\usage{
L1centMDS(g, tol, maxiter, verbose)

\method{L1centMDS}{igraph}(g, tol = 1e-05, maxiter = 1000, verbose = TRUE)

\method{L1centMDS}{matrix}(g, tol = 1e-05, maxiter = 1000, verbose = TRUE)

\method{plot}{L1centMDS}(x, zoom = 1, main = NULL, ...)
}
\arguments{
\item{g}{An \code{igraph} graph object or a distance matrix. The graph must
be undirected and connected. Equivalently, the distance matrix must be
symmetric, and all entries must be finite.}

\item{tol}{A numerical tolerance. The gradient descent method terminates if
the relative magnitude of the gradient falls below \code{tol} as in Kruskal
(1964b). By default set to \ifelse{html}{\out{10<sup>-5</sup>}}{\eqn{10^{-5}}}.}

\item{maxiter}{A number of maximum iteration allowances for the gradient descent
algorithm. By default set to 1000.}

\item{verbose}{A boolean.
\itemize{
\item \code{TRUE} (the default): for each iteration, prints (1) current number of
iterations, (2) current stress, and (3) relative magnitude of the gradient
to the console. At the end, the final message is printed to the console; total
number of iterations and final stress.
\item \code{FALSE}: suppress message to the console.
}}

\item{x}{An \code{L1centMDS} object, obtained as a result of the function
\code{L1centMDS()}.}

\item{zoom}{A numerical value on how much to zoom-in the plot. By default set
to 1 (no zoom).}

\item{main}{Title of the plot. If set to \code{NULL} (the default), the title
prints \dQuote{Target plot / Stress = X}.}

\item{...}{Further graphical parameters supplied to the internal
\code{\link[base:plot]{base::plot()}} (for points) and \code{\link[graphics:text]{graphics::text()}} (for labels) function.
See \code{\link[graphics:par]{graphics::par()}} document. To supply an argument to the former one,
use the prefix \sQuote{\code{plot.}} and for the latter,
\sQuote{\code{text.}}. For instance, \code{plot.cex = 1} sets the size of
the point, whereas \code{text.cex = 1} sets the size of the label.}
}
\value{
\code{L1centMDS()} returns an object of class \code{L1centMDS}. It is a list
consisting of four vectors:
\itemize{
\item \sQuote{label}: If \code{g} is an \code{igraph} object, \code{name}
attribute of the vertex. If \code{g} is a distance matrix, row names
(\code{rownames}). Is set to \code{NULL} if missing.
\item \sQuote{radius}: Radius of a point representing each vertex in the
target plot's circular coordinate system, i.e., \eqn{-\log(L_1\text{
 centrality})} for each vertex.
\item \sQuote{theta}: Angle (in radians) of a point representing each vertex
in the target plot's circular coordinate system.
\item \sQuote{stress}: Stress measure defined in Kruskal (1964a).
}

\code{plot.L1centMDS()} draws a target plot. Four concentric circles denote
the 1st to 4th quartiles of the radius, and the values of the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality quartiles
are shown in red text. Note that red texts denote the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality quartiles,
\emph{not} radius quartiles.
}
\description{
\code{L1centMDS()} and \code{plot.L1centMDS()} are used together to draw a
target plot, which is a target-shaped 2D plot that aids in the visual
inspection of an undirected graph using the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality. See Kang
and Oh (2024) for a formal definition of a target plot.
}
\details{
Denoting the \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality of vertex \eqn{i} as \eqn{c_i\in(0,1]}, a point representing that vertex is placed
on a concentric circle with radius \eqn{r_i =
-\log(c_i)}. Representing each vertex as \eqn{(r_i, \theta_i)} (in circular
coordinates), the values of \eqn{\theta_i} are derived using nonmetric
multidimensional scaling proposed in Kruskal (1964a,b). The initial
configuration is derived using classical multidimensional scaling
(\code{\link[stats:cmdscale]{stats::cmdscale()}}). A gradient descent algorithm is employed in deriving
optimal \eqn{\theta_i}s.
}
\note{
The function \code{L1centMDS()} is valid only for undirected and connected
graphs. Also, \code{L1centMDS()} only considers graphs with equal vertex
multiplicities.
}
\examples{
parameters <- L1centMDS(MCUmovie, verbose = FALSE)
plot(parameters)
}
\references{
S. Kang and H.-S. Oh. On a notion of graph centrality based on
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} data depth.
\emph{arXiv preprint arXiv:2404.13233}, 2024.

J. B. Kruskal. Multidimensional scaling by optimizing goodness of fit to a
nonmetric hypothesis. \emph{Psychometrika}, 29(1):1--27, 1964a.

J. B. Kruskal. Nonmetric multidimensional scaling: a numerical method.
\emph{Psychometrika}, 29(2): 115--129, 1964b.
}
\seealso{
\code{\link[=L1cent]{L1cent()}} for
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality/prestige,
\code{\link[MASS:isoMDS]{MASS::isoMDS()}} and \code{\link[stats:cmdscale]{stats::cmdscale()}} for multidimensional scaling
methods.
}
