% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L1centGROUP.R
\name{L1centGROUP}
\alias{L1centGROUP}
\alias{L1presGROUP}
\alias{L1centGROUP.igraph}
\alias{L1centGROUP.matrix}
\title{Group L1 Centrality/Prestige}
\usage{
L1centGROUP(g, nodes, eta, mode, method)

\method{L1centGROUP}{igraph}(
  g,
  nodes,
  eta = NULL,
  mode = c("centrality", "prestige"),
  method = c("minimum", "maximum", "average")
)

\method{L1centGROUP}{matrix}(
  g,
  nodes,
  eta = NULL,
  mode = c("centrality", "prestige"),
  method = "minimum"
)
}
\arguments{
\item{g}{An \code{igraph} graph object or a distance matrix. The graph must
be connected. For a directed graph, it must be strongly connected.
Equivalently, all entries of the distance matrix must be finite. Here, the
\ifelse{html}{\out{(<i>i,j</i>)}}{\eqn{(i,j)}} component of the distance
matrix is the geodesic distance from the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th vertex to the
\ifelse{html}{\out{<i>j</i>}}{\eqn{j}}th vertex.}

\item{nodes}{A vector of integers. Each integer indicates the index of the
vertex.}

\item{eta}{An optional nonnegative multiplicity (weight) vector for (vertex)
weighted networks. The sum of its components must be positive. If set to
\code{NULL} (the default), all vertices will have the same positive weight
(multiplicity) of 1, i.e., \code{g} is treated as a vertex unweighted graph. The
length of the \code{eta} must be equivalent to the number of vertices.}

\item{mode}{A character string. For an undirected graph, either choice gives
the same result.
\itemize{
\item \code{centrality} (the default): \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality (prominence of each vertex in terms of \emph{making} a choice) is
used for analysis.
\item \code{prestige}: \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
prestige (prominence of each vertex in terms of \emph{receiving} a choice)
is used for analysis.
}}

\item{method}{A character string. It specifies the method of setting the edge
weight between the pseudo-vertex and the other vertices. Note that the S3
method for the \code{matrix} class only supports the \code{minimum} option. This
is because it is not possible to derive the group reduced graph's distance
matrix from the original distance matrix when using the maximum or average
method. On the other hand, the group reduced graph's distance matrix can be
derived from the original distance matrix when the minimum method is used.
See the discussion in Kang (2025).
\itemize{
\item \code{minimum} (the default): the minimum method is used in setting the edge weights.
\item \code{maximum}: the maximum method is used in setting the edge weights.
\item \code{average}: the average method is used in setting the edge weights.
}}
}
\value{
A list consisting of two objects:
\itemize{
\item \sQuote{prominence}: The group
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality (if
\code{mode = "centrality"}) or the group
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prestige (if
\code{mode = "prestige"}) of the specified group of vertices.
\item \sQuote{label}: A vector of the vertex names specified by \code{nodes}.
}
}
\description{
Computes group \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality or group \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
prestige for the specified group of vertices. For undirected graphs, the two
measures are identical.
}
\details{
Given a group of vertices on a graph, we first construct a group reduced
graph by replacing the group of vertices by a single \sQuote{pseudo-vertex}
(see \code{\link[=group_reduce]{group_reduce()}} for the method of setting vertex multiplicities and
edge weights in the group reduced graph). The group
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality (prestige)
of this group is defined as the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality (prestige)
of the pseudo-vertex in the group reduced graph.
}
\note{
The function is valid only for connected graphs. If the graph is directed, it
must be strongly connected. Multiple edges (edges with the same head and tail
vertices) are not allowed, because they make the edge weight setting procedure
confusing.
}
\examples{
# Group L1 centrality of the 'Spider-Man' series
vertex_weight <- igraph::V(MCUmovie)$worldwidegross
L1centGROUP(MCUmovie, nodes = c(16,23,27), eta = vertex_weight)
}
\references{
S. Kang. \emph{Topics in Non-Euclidean Dimension Reduction}. PhD thesis,
Seoul National University, 2025.
}
\seealso{
\code{\link[=L1cent]{L1cent()}} for \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality/prestige, \code{\link[=group_reduce]{group_reduce()}} for details on the minimum, maximum, and average methods.
}
