/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell.korean;

import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.search.spell.KoLevensteinDistance;
import org.apache.lucene.search.spell.korean.HangulException;
import org.apache.lucene.search.spell.korean.KoHangul;
import org.apache.lucene.search.spell.korean.KoHangulSepllTokenizer;
import org.junit.Assert;
import org.junit.Test;

public class HangulTest {
    @Test
    public void testKoHangul() throws HangulException {
        char test1 = '\uc804';
        char[] ret = KoHangul.convertHangulSyllableToJamo(test1);
        char test1Res = KoHangul.convertJamosToHangulSyllable(ret);
        Assert.assertTrue((test1Res == test1 ? 1 : 0) != 0);
        char test2 = '\uafda';
        char[] ret2 = KoHangul.convertHangulSyllableToJamo(test2);
        char test2Res = KoHangul.convertJamosToHangulSyllable(ret2);
        Assert.assertTrue((test2Res == test2 ? 1 : 0) != 0);
    }

    @Test
    public void testConvertHangulStringToJamos() throws HangulException {
        String jamos = KoHangul.convertHangulStringToJamos("\uc804 \ud76c\uc6d0asd", true);
        String expected = "\u3148\u3153\u3134\uff5c \uff5c\u314e\u3162\uff5c\u3147\u315d\u3134\uff5ca\uff5cs\uff5cd\uff5c";
        System.out.println(jamos);
        Assert.assertTrue((boolean)jamos.equals(expected));
    }

    @Test
    public void testConvertHangulStringToKeyStrokes() {
        String ret = KoHangul.convertHangulStringToKeyStrokes("\uac80\uc0c9\uc5d4\u3147\u314f\uc9c41 234abcdfrA", true);
        System.out.println(ret);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testStandardTokenizer() throws IOException {
        KoHangulSepllTokenizer tokenizer = new KoHangulSepllTokenizer(new StringReader(";;;a123a4abcd\uac80\uc0c9\uc5d4\uc9c4\u771e;;;+a122=="));
        Token nextTok = new Token();
        while (tokenizer.next(nextTok) != null) {
            System.out.println(nextTok);
            nextTok.clear();
        }
    }

    @Test
    public void testKoLevensteinDistance() {
        KoLevensteinDistance dist = new KoLevensteinDistance();
        System.out.println(dist.getDistance("abcda", "abcd"));
    }
}

