% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kg_use_palette.R
\name{scale_color_kg}
\alias{scale_color_kg}
\alias{scale_colour_kg}
\title{Use color scales on 'ggplot2'}
\usage{
scale_color_kg(
  name = "Sapporo_Sta",
  alpha = 1,
  na.value = "red",
  discrete = TRUE
)

scale_colour_kg(
  name = "Sapporo_Sta",
  alpha = 1,
  na.value = "red",
  discrete = TRUE
)
}
\arguments{
\item{name}{color palette name. (default: \code{"Sapporo_Sta"})}

\item{alpha}{The alpha transparency. Numbers range from 0-1. see argument
alpha in \code{\link[grDevices]{rgb}}.}

\item{na.value}{Color of missing value.}

\item{discrete}{Generate a discrete palette. (\code{FALSE} - generate
continuous palette)}
}
\value{
Create a user defined color palette for ggplot2.
}
\description{
{scale_color_kg} Use color palette on 'ggplot2' colors.
}
\examples{
library("ggplot2")
ggplot(data = diamonds, aes(x = cut, y = price,
                            color = cut, fill = cut)) +
  geom_boxplot() +
  scale_color_kg(name = "Hanamushiro", alpha = 0.2) +
  scale_fill_kg(name = "Hokkaido_Sky", alpha = 0.2) +
  theme_dark()
}
