% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefKspm.R
\name{coef.kspm}
\alias{coef.kspm}
\title{Extract Model Coefficients}
\usage{
\method{coef}{kspm}(object, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}.}

\item{...}{additional optional argument (currently unused).}
}
\value{
Two matrices of coefficients.
\item{linear}{A vector of coefficients for linear part. One row is one variable.}
\item{kernel}{A matrix of coefficients for linear part. One row is one subject, one column is one kernel part.}
}
\description{
Returns linear and kernel coefficients for a model of class "kspm".
}
\examples{
x <- 1:15
z1 <- runif(15, 1, 6)
z2 <- rnorm(15, 1, 2)
y <- 3*x + (z1 + z2)^2 + rnorm(15, 0, 2)
fit <- kspm(y, linear = ~ x, kernel = ~ Kernel(~ z1 + z2,
kernel.function = "polynomial", d= 2, rho = 1, gamma = 0))
coef(fit)

}
\references{
Liu, D., Lin, X., and Ghosh, D. (2007). Semiparametric regression of multidimensional genetic pathway data: least squares kernel machines and linear mixed models. Biometrics, 63(4), 1079:1088.
}
\seealso{
\link{kspm} for fitting model.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
