% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedisimu.R
\name{pedisimu}
\alias{pedisimu}
\title{Pedigree simulation}
\usage{
pedisimu(
  af,
  ss,
  pedi,
  random_name = "RI",
  muf = 0,
  mum = 0,
  allelename = FALSE
)
}
\arguments{
\item{af}{name of allele frequency matrix, a data.frame of 1 column containing frequencies with allele names being row names, which can be loaded with "EvaluatePanel" function, not necessary if Parent is not NULL}

\item{ss}{sample size, i.e., how many individual pairs do you want simulate}

\item{pedi}{a matrix in data.frame form containing the pedigree structure information}

\item{random_name}{the name of random individual, with a default of "RI"}

\item{muf}{father-child mutation rate}

\item{mum}{mother-child mutation rate}

\item{allelename}{if TRUE the output data would be the allele name, which should be the row names of af matrix, otherwise, it would be the position in that matrix}
}
\value{
A data.frame with \code{ss} rows and 2*\code{n} columns, where \code{n} is equal to the number of rows in the pedi data.frame. Each pair of columns contains alleles of an individual, with the individuals sorted in the same order as in the pedi data.frame.
}
\description{
Generating genotype combinations of multiple pedigrees with specific relationships on an autosomal marker.
}
\examples{
#simulating a first cousin pedigree without considring mutation
pedi<-pediexample
af<-FortytwoSTR$afmatrix[[1]]
pedisimu(af = af,ss = 10000,pedi = pedi)


}
