% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_states.R
\name{rename_states}
\alias{rename_states}
\title{Rename the States of SSModel Object}
\usage{
rename_states(model, state_names)
}
\arguments{
\item{model}{Object of class SSModel}

\item{state_names}{Character vector giving new names for the states.}
}
\value{
Original model with dimnames corresponding to states renamed.
}
\description{
A simple function for renaming the states of \code{\link{SSModel}} object. 
Note that since KFAS version 1.2.3 the auxiliary functions such as 
\code{\link{SSMtrend}} have argument \code{state_names} which can be used to 
overwrite the default state names when building the model with \code{\link{SSModel}}.
}
\examples{
custom_model <- SSModel(1:10 ~ -1 + 
SSMcustom(Z = 1, T = 1, R = 1, Q = 1, P1inf = 1), H = 1) 
custom_model <- rename_states(custom_model, "level")
ll_model <- SSModel(1:10 ~ SSMtrend(1, Q = 1), H = 1)
test_these <- c("y", "Z", "H", "T", "R", "Q", "a1", "P1", "P1inf")
identical(custom_model[test_these], ll_model[test_these])

}
