% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/returngraph.R
\name{returngraph.diffee}
\alias{returngraph.diffee}
\title{return igraph object from diffee result specified by user input}
\usage{
\method{returngraph}{diffee}(x, type = "task",
  neighbouroption = "task", subID = NULL, index = NULL, ...)
}
\arguments{
\item{x}{output generated from diffee function (diffee class)}

\item{type}{type of graph. There are two options:
\itemize{
\item "task" (difference graph)
\item "neighbour" (zoom into nodes in the difference graph specified further by parameter
\strong{"index"} (node id)
}}

\item{neighbouroption}{unused}

\item{subID}{unused}

\item{index}{determines which node(s) to zoom into when parameter \strong{"type"} is \strong{"neighbour"}.
This parameter could either be an integer or vector of integers representing node ids
(zoom into one node or multiple nodes)}

\item{...}{unused}
}
\value{
an igraph object of graph / subgraph from diffee result specified by user input
}
\description{
This function can return an igraph object from diffee result for user to work with directly
}
\details{
the function aims to provide users the flexibility to explore and visualize the graph own their own
generated from diffee
}
\examples{
library(JointNets)
data(exampleData)
result = diffee(exampleData[[1]], exampleData[[2]], 0.45)
graph = returngraph(result)
}
\author{
Beilun Wang, Zhaoyang Wang (Author), Zhaoyang Wang (maintainer) \email{zw4dn@virginia.edu}
}
